import { CACHE_MANAGER } from '@nestjs/cache-manager';
import {
  Inject,
  Injectable,
  NotAcceptableException,
  NotFoundException,
} from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Cache } from 'cache-manager';
import { Repository } from 'typeorm';
import {
  CreateUserPermissionDto,
  UpdateUserPermissionDto,
} from './dto/permission.dto';
import { UserPermission } from './entities/user-permission.entity';
import { BoolStatusDto } from 'src/common/dto/bool-status.dto';

@Injectable()
export class UserPermissionsService {
  constructor(
    @InjectRepository(UserPermission)
    private readonly repo: Repository<UserPermission>,
    @Inject(CACHE_MANAGER) private readonly cacheManager: Cache,
  ) {}

  async create(dto: CreateUserPermissionDto[]) {
    return this.repo.save(dto);
  }

  findAll(accountId: string) {
    return this.repo.find({
      relations: ['permission', 'menu'],
      where: { accountId },
    });
  }

  async permissionUpdate(
    accountId: string,
    menuId: number,
    permissionId: number,
    status: boolean,
  ) {
    const perm = await this.repo.findOne({
      where: {
        accountId: accountId,
        menuId: menuId,
        permissionId: permissionId,
      },
    });

    if (perm) {
      const obj = Object.assign(perm, { status: status });
      return this.repo.save(obj);
    } else {
      return;
    }
  }

  async update(dto: UpdateUserPermissionDto[]) {
    try {
      this.delPermissions(dto[0].accountId);
      return this.repo.save(dto);
    } catch (error) {
      throw new NotAcceptableException(
        'Something bad happened! Try after some time!',
      );
    }
  }

  private delPermissions(id: string) {
    this.cacheManager.del('userPermission' + id);
  }
}
