import {
  ConflictException,
  Injectable,
  NotFoundException,
} from '@nestjs/common';
import { CreatePolicyMasterDto } from './dto/create-policy-master.dto';
import { UpdatePolicyMasterDto } from './dto/update-policy-master.dto';
import { PolicyMaster } from './entities/policy-master.entity';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';

@Injectable()
export class PolicyMasterService {
  constructor(
    @InjectRepository(PolicyMaster)
    private readonly repo: Repository<PolicyMaster>,
  ) {}

  async create(dto: CreatePolicyMasterDto) {
    const result = await this.repo.findOne({
      where: { desc: dto.desc, accountId: dto.accountId },
    });
    if (result) {
      throw new ConflictException(
        'This floating message already exists for this business!',
      );
    }
    const obj = Object.assign(dto);
    return this.repo.save(obj);
  }

  async find(accountId: string) {
    const [result, total] = await this.repo.findAndCount({
      where: { accountId },
    });
    if (!result) {
      throw new NotFoundException('No policy center found for this business');
    }
    return { result, total };
  }

  async update(id: string, dto: UpdatePolicyMasterDto) {
     const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('No floating message found');
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }

  async remove(id: string) {
     const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('No floating message found');
    }
    return this.repo.remove(result);
  }
}
