import { MailerModule } from '@nestjs-modules/mailer';
import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { NodeMailerController } from './node-mailer.controller';
import { NodeMailerService } from './node-mailer.service';
import { BusinessEmail } from 'src/business-email/entities/business-email.entity';
import { TypeOrmModule } from '@nestjs/typeorm';

@Module({
  imports: [
    ConfigModule.forRoot({ isGlobal: true }),
    MailerModule,
    TypeOrmModule.forFeature([BusinessEmail]),
  ],
  controllers: [NodeMailerController],
  providers: [NodeMailerService],
  exports: [NodeMailerService],
})
export class NodeMailerModule {}
