import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  UseGuards,
  Put,
} from '@nestjs/common';
import { BusinessPaymentService } from './business-payment.service';
import { CreateBusinessPaymentDto } from './dto/create-business-payment.dto';
import { UpdateBusinessPaymentDto } from './dto/update-business-payment.dto';
import { AuthGuard } from '@nestjs/passport';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { CurrentUser } from 'src/auth/decorators/current-user.decorator';
import { Account } from 'src/account/entities/account.entity';
import { DefaultStatusDto } from 'src/common/dto/default-status.dto';

@Controller('business-payment')
export class BusinessPaymentController {
  constructor(
    private readonly businessPaymentService: BusinessPaymentService,
  ) {}

  @Post()
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.BUSINESS)
  create(@Body() dto: CreateBusinessPaymentDto, @CurrentUser() user: Account) {
    dto.accountId = user.id;
    return this.businessPaymentService.create(dto);
  }

  @Patch('update')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.BUSINESS)
  update(@CurrentUser() user: Account, @Body() dto: UpdateBusinessPaymentDto) {
    return this.businessPaymentService.update(user.id, dto);
  }

  @Put(':id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.BUSINESS)
  status(@Param('id') id: string, @Body() dto: DefaultStatusDto) {
    return this.businessPaymentService.status(id, dto);
  }
}
