import { Account } from 'src/account/entities/account.entity';
import { MasterPaymentMode } from 'src/enum';
import { Column, CreateDateColumn, Entity, ManyToOne, PrimaryGeneratedColumn, UpdateDateColumn } from 'typeorm';

@Entity()
export class BusinessPaymentRecord {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'varchar', length: 1000, nullable: true })
  subject: string;

  @Column({ type: 'varchar', length: 1000, nullable: true })
  invoiceNumber: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  transactionId: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  businessName: string;

  @Column({ type: 'double', nullable: true })
  subTotal: number;

  @Column({ type: 'double', nullable: true })
  total: number;

  @Column({ type: 'double', nullable: true })
  paid: number;

  @Column({ type: 'double', nullable: true })
  amountDue: number;

  @Column({ type: 'enum', enum: MasterPaymentMode, nullable: true })
  paymentMode: MasterPaymentMode;

  @Column({ type: 'date', nullable: true })
  paymentDate: Date;

  @Column({ type: 'varchar', length: 7000, nullable: true })
  note: string;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Account, (account) => account.businessPaymentRecord, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];
}
