import { Type } from 'class-transformer';
import { IsOptional } from 'class-validator';
import { MasterPaymentMode } from 'src/enum';

export class UpdateBusinessPaymentRecordDto {
  @IsOptional()
  subject: string;

  @IsOptional()
  transactionId: string;

  @IsOptional()
  businessName: string;

  @IsOptional()
  @Type(() => Number)
  amountPaid: number;

  @IsOptional()
  @Type(() => Number)
  amountDue: number;

  @IsOptional()
  paymentMode: MasterPaymentMode;

  @IsOptional()
  paymentDate: Date;

  @IsOptional()
  note: string;
}
