import { Module } from '@nestjs/common';
import { BusinessPaymentRecordService } from './business-payment-record.service';
import { BusinessPaymentRecordController } from './business-payment-record.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { BusinessPaymentRecord } from './entities/business-payment-record.entity';
import { Business } from 'src/business/entities/business.entity';
import { Tax } from 'src/tax/entities/tax.entity';

@Module({
  imports:[TypeOrmModule.forFeature([BusinessPaymentRecord, Business,Tax]),AuthModule],
  controllers: [BusinessPaymentRecordController],
  providers: [BusinessPaymentRecordService],
})
export class BusinessPaymentRecordModule {}
