import { Account } from 'src/account/entities/account.entity';
import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from 'typeorm';

@Entity()
export class AdminDetail {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  userName: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  phoneNumber: string;

  @Column({type: 'text', nullable: true})
  profileImage: string;

  @Column({type: 'text', nullable: true})
  profileImagePath: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  smsRoute: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  smsSenderId: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  smsApiKey: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @ManyToOne(() => Account, (account) => account.adminDetail)
  account: Account[];
}
