import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';

import { AuthModule } from 'src/auth/auth.module';
import { MenusModule } from 'src/menus/menus.module';
import { PermissionsModule } from 'src/permissions/permissions.module';
import { UserPermissionsModule } from 'src/user-permissions/user-permissions.module';
import { AccountController } from './account.controller';
import { AccountService } from './account.service';
import { Account } from './entities/account.entity';
import { UserDetail } from 'src/user-details/entities/user-detail.entity';
import { NodeMailerModule } from 'src/node-mailer/node-mailer.module';
import { StaffDetail } from 'src/staff-details/entities/staff-detail.entity';
import { Menu } from 'src/menus/entities/menu.entity';
import { MembershipCard } from 'src/membership-card/entities/membership-card.entity';
import { Business } from 'src/business/entities/business.entity';
import { BusinessEmail } from 'src/business-email/entities/business-email.entity';
import { BusinessPayment } from 'src/business-payment/entities/business-payment.entity';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Account,
      UserDetail,
      StaffDetail,
      Menu,
      MembershipCard,
      Business,
      BusinessEmail,
      BusinessPayment,
    ]),
    AuthModule,
    MenusModule,
    PermissionsModule,
    UserPermissionsModule,
    NodeMailerModule,
  ],
  controllers: [AccountController],
  providers: [AccountService],
  exports: [AccountService],
})
export class AccountModule {}
