import axios from 'axios';

export async function sendOtp(phone: number, otp: number) {
  try {
    const msg = `Dear User, your OTP for login to Cluenex is ${otp}. Please do not share it with anyone. Regards, Cluenex`;

    const params = {
      UserID: process.env.CLU_OTP_USERID,
      Password: process.env.CLU_OTP_PASSWORD,
      SenderID: process.env.CLU_OTP_SENDERID, // e.g. CLUNEX
      Phno: phone,
      Msg: msg,
      EntityID: process.env.CLU_OTP_ENTITYID, // e.g. 170************590
      TemplateID: process.env.CLU_OTP_TEMPLATE, // e.g. 1707176224785125867
    };
    const url = `http://nimbusit.net/api/pushsms?user=${params.UserID}&authkey=${params.Password}&sender=${params.SenderID}&mobile=+91${params.Phno}&text=${params.Msg}&entityid=${params.EntityID}&templateid=${params.TemplateID}&rpt=1`;

    const { data } = await axios.get(url);
    if (data.Status?.toUpperCase() === 'OK') {
      return true;
    }
    console.log('Nimbus response:', data);
    return false;
  } catch (error: any) {
    console.error('SMS send error:', error.message);
    return false;
  }
}

export async function sendSMS(
  phone: number,
  message: string,
  templateId: number,
) {
  try {
    const msg = encodeURIComponent(message);

    const payload = await axios.get(
      `http://nimbusit.biz/api/SmsApi/SendSingleApi?UserID=${process.env.PV_OTP_USERID}&Password=${process.env.PV_OTP_PASSWORD}&SenderID=${process.env.CLU_OTP_SENDERID}&Phno=${phone}&Msg=${msg}&EntityID=${process.env.PV_OTP_ENTITYID}&TemplateID=${templateId}`,
      {
        headers: {},
      },
    );
    if (payload.data.Status == 'OK') {
      return true;
    } else {
      return null;
    }
  } catch (error) {
    return null;
  }
}
