import { Module } from '@nestjs/common';
import { UserGameService } from './user-game.service';
import { UserGameController } from './user-game.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { UserGame } from './entities/user-game.entity';
import { Account } from 'src/account/entities/account.entity';
import { Game } from 'src/game/entities/game.entity';
import { UserCategory } from 'src/user-category/entities/user-category.entity';

@Module({
  imports: [TypeOrmModule.forFeature([UserGame, Account, Game, UserCategory]), AuthModule],
  controllers: [UserGameController],
  providers: [UserGameService],
})
export class UserGameModule {}
