import { Type } from 'class-transformer';
import { IsEnum, IsNotEmpty, IsOptional } from 'class-validator';
import { PlayGameStatus } from 'src/enum';

export class CreateUserGameDto {
  @IsOptional()
  accountId: string;

  @IsNotEmpty()
  gameId: string;

  @IsOptional()
  @Type(() => Number)
  totalDuration: number;

  @IsOptional()
  @Type(() => Number)
  earnedPoint: number;

  @IsNotEmpty()
  @IsEnum(PlayGameStatus)
  status: PlayGameStatus;

  @IsOptional()
  @Type(() => Number)
  attemptCount: number;

  @IsOptional()
  @Type(() => Number)
  correctCount: number;
}
