import { Type } from 'class-transformer';
import {
  IsString,
  MinLength,
  MaxLength,
  IsOptional,
  IsNotEmpty,
  IsNumber,
  Max,
  Min,
} from 'class-validator';

export class RegisterUserDetailDto {
  @IsOptional()
  @IsString()
  @MaxLength(50)
  name: string;

  @IsOptional()
  @IsString()
  @MaxLength(50)
  userName: string;

  @IsOptional()
  @MinLength(0)
  @MaxLength(100)
  dob: string;

  @IsOptional()
  @MinLength(0)
  @MaxLength(10)
  gender: string;
  
  @IsOptional()
  @IsString()
  @MaxLength(50)
  email: string;

  @IsOptional()
  avatar: string;

  @IsOptional()
  cityId: string;

  @IsOptional()
  accountId: string;
}

export class PaginationSDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(50)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsOptional()
  keyword: string;
}
