import { Injectable, NotFoundException } from '@nestjs/common';
import {
  CreateUserCategoryDto,
  UserCategoryPlayStatus,
} from './dto/create-user-category.dto';
import { UpdateUserCategoryDto } from './dto/update-user-category.dto';
import { UserCategory } from './entities/user-category.entity';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { PlayGameStatus } from 'src/enum';
import { UserGame } from 'src/user-game/entities/user-game.entity';

@Injectable()
export class UserCategoryService {
  constructor(
    @InjectRepository(UserCategory)
    private readonly repo: Repository<UserCategory>,
    @InjectRepository(UserGame)
    private readonly uGrepo: Repository<UserGame>,
  ) {}

  async create(dto: CreateUserCategoryDto) {
    const result = await this.repo.findOne({
      where: {
        accountId: dto.accountId,
        categoryId: dto.categoryId,
      },
    });
    if (result) {
      const obj = Object.assign(result, {
        accountId: dto.accountId,
        categoryId: dto.categoryId,
      });
      return this.repo.save(obj);
    }
    const obj = Object.assign(dto);
    return this.repo.save(obj);
  }

  async status(
    categoryId: string,
    dto: UserCategoryPlayStatus,
    accountId: string,
  ) {
    //calculate accuracy
    const [userGame, total] = await this.uGrepo.findAndCount({
      where: { categoryId, accountId },
    });
    let totalAccuracy = 0;
    let totalDuration = 0;
    userGame.forEach((item) => {
      totalAccuracy += item.accuracy;
      totalDuration += item.totalDuration;
    });
    const accuracy = totalAccuracy / total;
    const duration = totalDuration / total;

    const result = await this.repo.findOne({
      where: { categoryId, accountId, status: PlayGameStatus.IN_COMPLETED },
    });
    if (!result) {
      throw new NotFoundException('Not Found..');
    }
    const obj = Object.assign(result, {
      status: dto.status,
      accuracy: accuracy,
      avgDuration: duration
    });
    return this.repo.save(obj);
  }
}
