import { Module } from '@nestjs/common';
import { UserCategoryService } from './user-category.service';
import { UserCategoryController } from './user-category.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { UserCategory } from './entities/user-category.entity';
import { UserGame } from 'src/user-game/entities/user-game.entity';

@Module({
  imports: [TypeOrmModule.forFeature([UserCategory, UserGame]), AuthModule],
  controllers: [UserCategoryController],
  providers: [UserCategoryService],
})
export class UserCategoryModule {}
