import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  UseGuards,
  Put,
} from '@nestjs/common';
import { UserCategoryService } from './user-category.service';
import {
  CreateUserCategoryDto,
  UserCategoryPlayStatus,
} from './dto/create-user-category.dto';
import { AuthGuard } from '@nestjs/passport';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { CurrentUser } from 'src/auth/decorators/current-user.decorator';
import { Account } from 'src/account/entities/account.entity';

@Controller('user-category')
export class UserCategoryController {
  constructor(private readonly userCategoryService: UserCategoryService) {}

  @Post()
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.USER)
  create(@Body() dto: CreateUserCategoryDto, @CurrentUser() user: Account) {
    dto.accountId = user.id;
    return this.userCategoryService.create(dto);
  }

  @Put('status/:categoryId')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.USER)
  status(
    @Param('categoryId') categoryId: string,
    @Body() dto: UserCategoryPlayStatus,
    @CurrentUser() user: Account,
  ) {
    return this.userCategoryService.status(categoryId, dto, user.id);
  }
}
