import { Account } from 'src/account/entities/account.entity';
import { Category } from 'src/category/entities/category.entity';
import { PlayGameStatus } from 'src/enum';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class UserCategory {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'uuid', nullable: true })
  categoryId: string;

  @Column({ type: 'date', nullable: true })
  playDate: Date;

  @Column({
    type: 'enum',
    enum: PlayGameStatus,
    default: PlayGameStatus.IN_COMPLETED,
  })
  status: PlayGameStatus;

  @Column({ type: 'float', default: 0, nullable: true })
  accuracy: number;

  @Column({ type: 'int', default: 0, nullable: true })
  avgDuration: number;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Account, (account) => account.userCategory, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  account: Account[];

  @ManyToOne(() => Category, (category) => category.userCategory, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  category: Category[];
}
