import { IsEnum, IsNotEmpty, IsOptional } from 'class-validator';
import { PlayGameStatus } from 'src/enum';

export class CreateUserCategoryDto {
  @IsOptional()
  accountId: string;

  @IsNotEmpty()
  categoryId: string;

  @IsNotEmpty()
  playDate: Date;
}

export class UserCategoryPlayStatus{
  @IsNotEmpty()
  @IsEnum(PlayGameStatus)
  status: PlayGameStatus;
}
