import { ConflictException, Injectable } from '@nestjs/common';
import { CreateUserCaseDto, ReviewResultDto } from './dto/create-user-case.dto';
import { UpdateUserCaseDto } from './dto/update-user-case.dto';
import { UserCase } from './entities/user-case.entity';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';
import { CasePassStatus } from 'src/enum';
import { Case } from 'src/case/entities/case.entity';

@Injectable()
export class UserCaseService {
  constructor(
    @InjectRepository(UserCase) private readonly repo: Repository<UserCase>,
    @InjectRepository(Case) private readonly caseRepo: Repository<Case>,
  ) {}

  async create(dto: CreateUserCaseDto, accountId: string) {
    const result = await this.repo.findOne({
      where: { accountId, gameId: dto.gameId, caseId: dto.caseId },
    });
    if (result) {
      const obj = Object.assign(result, {
        selectAnsNum: dto.selectAnsNum,
        casePassStatus: dto.casePassStatus,
      });
      return this.repo.save(obj);
    }
    const obj = Object.assign(dto);
    return this.repo.save(obj);
  }

  async resultPreview(accountId: string, dto: ReviewResultDto) {
    const [result, total] = await this.repo
      .createQueryBuilder('userCase')
      .leftJoinAndSelect('userCase.case', 'case')
      .where(
        'userCase.gameId IN (:...ids) AND userCase.accountId = :accountId',
        {
          ids: dto.gameId,
          accountId,
        },
      )
      .orderBy({ 'userCase.createdAt': 'ASC' })
      .take(dto.limit)
      .skip(dto.offset)
      .getManyAndCount();
    return { result, total };
  }

  async getUnplayedCount(gameId: string, accountId: string) {
    const totalPlayedCount = await this.repo.count({
      where: { gameId, accountId, casePassStatus: CasePassStatus.ATTEMPTED },
    });

    const totalCasesCount = await this.caseRepo.count({ where: { gameId } });

    return { totalPlayed: totalPlayedCount, totalCases: totalCasesCount };
  }

  findOne(id: number) {
    return `This action returns a #${id} userCase`;
  }
}
