import { Module } from '@nestjs/common';
import { UserCaseService } from './user-case.service';
import { UserCaseController } from './user-case.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { UserCase } from './entities/user-case.entity';
import { Case } from 'src/case/entities/case.entity';

@Module({
  imports: [TypeOrmModule.forFeature([UserCase, Case]), AuthModule],
  controllers: [UserCaseController],
  providers: [UserCaseService],
})
export class UserCaseModule {}
