import { Account } from 'src/account/entities/account.entity';
import { Case } from 'src/case/entities/case.entity';
import { CasePassStatus, HintStatus } from 'src/enum';
import { Game } from 'src/game/entities/game.entity';
import { Column, CreateDateColumn, Entity, ManyToOne, PrimaryGeneratedColumn, UpdateDateColumn } from 'typeorm';

@Entity()
export class UserCase {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'uuid', nullable: true })
  gameId: string;

  @Column({ type: 'uuid', nullable: true })
  caseId: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  selectAnsNum: string;

  @Column({
    type: 'enum',
    enum: CasePassStatus,
    default: CasePassStatus.ATTEMPTED,
  })
  casePassStatus: CasePassStatus;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Account, (account) => account.userCase, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];

  @ManyToOne(() => Game, (game) => game.userCase, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  game: Game[];

  @ManyToOne(() => Case, (caseU) => caseU.userCase, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  case: Case[];
}
