import { Type } from 'class-transformer';
import {
  IsArray,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';
import { CasePassStatus } from 'src/enum';

export class CreateUserCaseDto {
  @IsOptional()
  accountId: string;

  @IsNotEmpty()
  gameId: string;

  @IsNotEmpty()
  caseId: string;

  @IsOptional()
  selectAnsNum: string;

  @IsNotEmpty()
  casePassStatus: CasePassStatus;
}

export class ReviewResultDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(5)
  @Max(100)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsNotEmpty()
  @IsArray()
  @IsString({ each: true })
  gameId: string[];
}
