import { Account } from 'src/account/entities/account.entity';
import { CaseFileAccess, DefaultStatus, PlanType, YNStatus } from 'src/enum';
import { PlanHistory } from 'src/plan-history/entities/plan-history.entity';
import {
  Entity,
  PrimaryGeneratedColumn,
  CreateDateColumn,
  UpdateDateColumn,
  Column,
  ManyToOne,
  OneToMany,
  OneToOne,
  JoinColumn,
} from 'typeorm';

@Entity()
export class Plan {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'enum', enum: PlanType, default: PlanType.MONTHLY })
  planType: PlanType;

  @Column({ type: 'varchar', length: 100, nullable: true })
  planName: string;

  @Column({ type: 'int', nullable: true })
  price: number;

  @Column({ type: 'varchar', length: 100, nullable: true })
  dailyPuzzleCount: string;

  @Column({
    type: 'enum',
    enum: CaseFileAccess,
    default: CaseFileAccess.IMMIDIATE,
  })
  caseFileAccess: CaseFileAccess;

  @Column({ type: 'int', nullable: true })
  freeDailyCoin: number;

  @Column({ type: 'enum', enum: YNStatus, default: YNStatus.NO })
  showAds: YNStatus;

  @Column({ type: 'text', nullable: true })
  desc: string;

  @Column({ type: 'enum', enum: DefaultStatus, default: DefaultStatus.PENDING })
  status: DefaultStatus;

  @Column({type: 'boolean', default: false})
  popular: boolean;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  // @JoinColumn()
  @OneToOne(() => Account, (account) => account.plan)
  account: Account;

  @OneToMany(() => PlanHistory, (planHistory) => planHistory.plan)
  planHistory: PlanHistory[];
}
