import { Transform, Type } from 'class-transformer';
import { IsBoolean, IsOptional } from 'class-validator';
import { PlanType, CaseFileAccess, YNStatus } from 'src/enum';

export class UpdatePlanDto {
  @IsOptional()
  @Transform(({ value }) => value === 'true')
  @IsBoolean()
  popular: boolean;

  @IsOptional()
  planType: PlanType;

  @IsOptional()
  planName: string;

  @IsOptional()
  @Type(() => Number)
  price: number;

  @IsOptional()
  dailyPuzzleCount: string;

  @IsOptional()
  caseFileAccess: CaseFileAccess;

  @IsOptional()
  @Type(() => Number)
  freeDailyCoin: number;

  @IsOptional()
  showAds: YNStatus;

  @IsOptional()
  desc: string;
}
