import { Transform, Type } from 'class-transformer';
import {
  IsBoolean,
  IsEnum,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';
import { PlanType, CaseFileAccess, YNStatus, DefaultStatus } from 'src/enum';

export class CreatePlanDto {
  @IsOptional()
  @Transform(({ value }) => value === 'true')
  @IsBoolean()
  popular: boolean;

  @IsNotEmpty()
  planType: PlanType;

  @IsNotEmpty()
  planName: string;

  @IsNotEmpty()
  @Type(() => Number)
  price: number;

  @IsNotEmpty()
  dailyPuzzleCount: string;

  @IsNotEmpty()
  caseFileAccess: CaseFileAccess;

  @IsNotEmpty()
  @Type(() => Number)
  freeDailyCoin: number;

  @IsNotEmpty()
  showAds: YNStatus;

  @IsNotEmpty()
  desc: string;
}

export class PlanPaginationDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(100)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(100)
  keyword: string;

  @IsOptional()
  status: DefaultStatus;

  @IsOptional()
  planType: PlanType;
}
