import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';
import { PlanHistory } from './entities/plan-history.entity';
import { Repository } from 'typeorm';

@Injectable()
export class PlanHistoryService {
  constructor(
    @InjectRepository(PlanHistory)
    private readonly repo: Repository<PlanHistory>,
  ) {}

  async findAll(dto: CommonPaginationDto, accountId: string) {
    const [result, total] = await this.repo.findAndCount({
      relations: ['plan'],
      where: { accountId },
      take: dto.limit,
      skip: dto.offset,
    });
    return { result, total };
  }
}
