import { Controller, Get, Param, Query, UseGuards } from '@nestjs/common';
import { PlanHistoryService } from './plan-history.service';
import { CurrentUser } from 'src/auth/decorators/current-user.decorator';
import { Account } from 'src/account/entities/account.entity';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';
import { AuthGuard } from '@nestjs/passport';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';

@Controller('plan-history')
export class PlanHistoryController {
  constructor(private readonly planHistoryService: PlanHistoryService) {}

  @Get('admin-history/:accountId')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  findByAdmin(
    @Param('accountId') accountId: string,
    @Query() dto: CommonPaginationDto,
  ) {
    return this.planHistoryService.findAll(dto, accountId);
  }

  @Get('history')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.USER)
  findAll(@CurrentUser() user: Account, @Query() dto: CommonPaginationDto) {
    return this.planHistoryService.findAll(dto, user.id);
  }
}
