import { Account } from 'src/account/entities/account.entity';
import { Plan } from 'src/plan/entities/plan.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class PlanHistory {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  planId: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'date', nullable: true })
  purchaseDate: Date;

  @ManyToOne(() => Plan, (plan) => plan.planHistory, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  plan: Plan[];

  @ManyToOne(() => Account, (account) => account.planHistory, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;
}
