import { Controller, Get, Post, Body, Patch, Param, Delete } from '@nestjs/common';
import { LeaderboardMonthlyService } from './leaderboard-monthly.service';
import { CreateLeaderboardMonthlyDto } from './dto/create-leaderboard-monthly.dto';
import { UpdateLeaderboardMonthlyDto } from './dto/update-leaderboard-monthly.dto';

@Controller('leaderboard-monthly')
export class LeaderboardMonthlyController {
  constructor(private readonly leaderboardMonthlyService: LeaderboardMonthlyService) {}

  @Post()
  create(@Body() createLeaderboardMonthlyDto: CreateLeaderboardMonthlyDto) {
    return this.leaderboardMonthlyService.create(createLeaderboardMonthlyDto);
  }

  @Get()
  findAll() {
    return this.leaderboardMonthlyService.findAll();
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.leaderboardMonthlyService.findOne(+id);
  }

  @Patch(':id')
  update(@Param('id') id: string, @Body() updateLeaderboardMonthlyDto: UpdateLeaderboardMonthlyDto) {
    return this.leaderboardMonthlyService.update(+id, updateLeaderboardMonthlyDto);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.leaderboardMonthlyService.remove(+id);
  }
}
