import { Module } from '@nestjs/common';
import { GameService } from './game.service';
import { GameController } from './game.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Game } from './entities/game.entity';
import { AuthModule } from 'src/auth/auth.module';
import { GameCronService } from './game.cron.service';

@Module({
  imports: [TypeOrmModule.forFeature([Game]), AuthModule],
  controllers: [GameController],
  providers: [GameService,GameCronService],
})
export class GameModule {}
