import { Case } from 'src/case/entities/case.entity';
import { Category } from 'src/category/entities/category.entity';
import { CategoryPublishStatus, DefaultStatus, GameType } from 'src/enum';
import { UserCase } from 'src/user-case/entities/user-case.entity';
import { UserGame } from 'src/user-game/entities/user-game.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class Game {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  categoryId: string;

  @Column({ type: 'varchar', length: 255, nullable: true })
  gameName: string;

  @Column({ type: 'varchar', length: 5000, nullable: true })
  gameDesc: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  resultTimer: string;

  @Column({ type: 'enum', enum: DefaultStatus, default: DefaultStatus.ACTIVE })
  status: DefaultStatus;

  @Column({ type: 'text', nullable: true })
  gameImage: string;

  @Column({ type: 'text', nullable: true })
  gameImagePath: string;

  @Column({ type: 'text', nullable: true })
  gameIcon: string;

  @Column({ type: 'text', nullable: true })
  gameIconPath: string;

  @Column({ type: 'date', nullable: true })
  publishDateFrom: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  gameOpenTimer: string;

  @Column({ type: 'date', nullable: true })
  publishDateTo: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  gameCloseTime: string;

  @Column({
    type: 'enum',
    enum: CategoryPublishStatus,
    default: CategoryPublishStatus.PUBLISH,
  })
  pubStatus: CategoryPublishStatus;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @Column({ type: 'enum', enum: GameType, nullable: true })
  type: GameType;

  @OneToMany(() => Case, (gameCase) => gameCase.game)
  case: Case[];

  @ManyToOne(() => Category, (category) => category.game, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  category: Category[];

  @OneToMany(() => UserGame, (userGame) => userGame.game)
  userGame: UserGame[];

  @OneToMany(() => UserCase, (userCase) => userCase.game)
  userCase: UserCase[];
}
