import { Account } from 'src/account/entities/account.entity';
import { FeedbackStatus } from 'src/enum';
import { FeedbackReply } from 'src/feedback-reply/entities/feedback-reply.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class Feedback {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'varchar', length: 1000, nullable: true })
  moduleName: string;

  @Column({ type: 'varchar', length: 1000, nullable: true })
  issueName: string;

  @Column({ type: 'varchar', length: 1000, nullable: true })
  suggestion: string;

  @Column({
    type: 'enum',
    enum: FeedbackStatus,
    default: FeedbackStatus.PENDING,
  })
  status: FeedbackStatus;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Account, (account) => account.feedback, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];

  @OneToMany(() => FeedbackReply, (feedbackReply) => feedbackReply.feedback)
  feedbackReply: FeedbackReply[];
}
