import { Type } from 'class-transformer';
import {
  IsEnum,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';
import { FeedbackStatus } from 'src/enum';

export class CreateFeedbackDto {
  @IsNotEmpty()
  moduleName: string;

  @IsNotEmpty()
  issueName: string;

  @IsNotEmpty()
  suggestion: string;

  @IsOptional()
  accountId: string;
}

export class FeedbackPaginationDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(5)
  @Max(100)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(100)
  keyword: string;

  @IsNotEmpty()
  @IsEnum(FeedbackStatus)
  status: FeedbackStatus;
}

export class FeedbackStatusDto{
  @IsNotEmpty()
  @IsEnum(FeedbackStatus)
  status: FeedbackStatus;
}
