import {
  BadRequestException,
  Injectable,
  NotFoundException,
} from '@nestjs/common';
import { CreateFeedbackReplyDto } from './dto/create-feedback-reply.dto';
import { UpdateFeedbackReplyDto } from './dto/update-feedback-reply.dto';
import { FeedbackReply } from './entities/feedback-reply.entity';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { Feedback } from 'src/feedback/entities/feedback.entity';
import { FeedbackStatus } from 'src/enum';

@Injectable()
export class FeedbackReplyService {
  constructor(
    @InjectRepository(FeedbackReply)
    private readonly repo: Repository<FeedbackReply>,
    @InjectRepository(Feedback)
    private readonly feedBackRepo: Repository<Feedback>,
  ) {}

  async create(dto: CreateFeedbackReplyDto) {
    const check = await this.feedBackRepo.findOne({
      where: { id: dto.feedbackId },
    });
    if (check.status != FeedbackStatus.PENDING) {
      throw new BadRequestException(`Feedback already ${check.status}`);
    }
    const obj = Object.assign(dto);
    return this.repo.save(obj);
  }

  async findAll(feedbackId: string) {
    const [result, total] = await this.repo.findAndCount({
      where: { feedbackId },
      order: { createdAt: 'ASC' },
    });
    if (!result) {
      throw new NotFoundException('No reply found!');
    }
    return { result, total };
  }
}
