import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
} from '@nestjs/common';
import { FeedbackReplyService } from './feedback-reply.service';
import { CreateFeedbackReplyDto } from './dto/create-feedback-reply.dto';
import { UpdateFeedbackReplyDto } from './dto/update-feedback-reply.dto';

@Controller('feedback-reply')
export class FeedbackReplyController {
  constructor(private readonly feedbackReplyService: FeedbackReplyService) {}

  @Post()
  create(@Body() dto: CreateFeedbackReplyDto) {
    return this.feedbackReplyService.create(dto);
  }

  @Get('reply/:feedbackId')
  findAll(@Param('feedbackId') feedbackId: string) {
    return this.feedbackReplyService.findAll(feedbackId);
  }
}
