import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  UseGuards,
  Query,
} from '@nestjs/common';
import { FeedbackIssueService } from './feedback-issue.service';
import { CreateFeedbackIssueDto } from './dto/create-feedback-issue.dto';
import { UpdateFeedbackIssueDto } from './dto/update-feedback-issue.dto';
import { AuthGuard } from '@nestjs/passport';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';

@Controller('feedback-issue')
export class FeedbackIssueController {
  constructor(private readonly feedbackIssueService: FeedbackIssueService) {}

  @Post()
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  create(@Body() dto: CreateFeedbackIssueDto) {
    return this.feedbackIssueService.create(dto);
  }

  @Get('list')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  findAll(@Query() dto: CommonPaginationDto) {
    return this.feedbackIssueService.findAll(dto);
  }

  @Get('user/list')
  find() {
    return this.feedbackIssueService.find();
  }

  @Patch('update/:id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  update(@Param('id') id: string, @Body() dto: CreateFeedbackIssueDto) {
    return this.feedbackIssueService.update(id, dto);
  }

  @Delete('remove/:id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  remove(@Param('id') id: string) {
    return this.feedbackIssueService.remove(id);
  }
}
