import { Transform, Type } from 'class-transformer';
import { IsBoolean, IsOptional } from 'class-validator';

export class UpdateCoinPackDto {
  @IsOptional()
  @Type(() => Number)
  price: number;

  @IsOptional()
  @Type(() => Number)
  coin: number;

  @IsOptional()
  @Transform(({ value }) => value === 'true')
  @IsBoolean()
  special: boolean;
}
