import { Transform, Type } from 'class-transformer';
import { IsBoolean, IsNotEmpty, IsOptional } from 'class-validator';

export class CreateCoinPackDto {
  @IsNotEmpty()
  @Type(() => Number)
  price: number;

  @IsNotEmpty()
  @Type(() => Number)
  coin: number;

  @IsOptional()
  @Transform(({ value }) => value === 'true')
  @IsBoolean()
  special: boolean;
}
