import {
  ConflictException,
  Injectable,
  NotFoundException,
} from '@nestjs/common';
import { CreateCoinPackDto } from './dto/create-coin-pack.dto';
import { UpdateCoinPackDto } from './dto/update-coin-pack.dto';
import { CoinPack } from './entities/coin-pack.entity';
import { InjectRepository } from '@nestjs/typeorm';
import { Brackets, Repository } from 'typeorm';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';

@Injectable()
export class CoinPackService {
  constructor(
    @InjectRepository(CoinPack) private readonly repo: Repository<CoinPack>,
  ) {}

  async create(dto: CreateCoinPackDto) {
    const result = await this.repo.findOne({
      where: { price: dto.price, coin: dto.coin },
    });
    if (result) {
      throw new ConflictException('This record already exists!');
    }
    const obj = Object.assign(dto);
    return this.repo.save(obj);
  }

  async findAll(dto: CommonPaginationDto) {
    const keyword = dto.keyword || '';
    const query = await this.repo.createQueryBuilder('coin');
    if (dto.keyword && dto.keyword.length > 0) {
      query.andWhere(
        new Brackets((qb) => {
          qb.where('coin.price LIKE :keyword', {
            keyword: '%' + keyword + '%',
          });
        }),
      );
    }
    const [result, total] = await query
      .orderBy({ 'coin.createdAt': 'DESC' })
      .take(dto.limit)
      .skip(dto.offset)
      .getManyAndCount();

    return { result, total };
  }

  async getSpecial() {
    const result = await this.repo.findOne({ where: { special: true } });
    if (!result) {
      throw new NotFoundException('Not found!');
    }
    return result;
  }

  async update(id: string, dto: UpdateCoinPackDto) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Not found!');
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }

  async remove(id: string) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Not found!');
    }
    return this.repo.remove(result);
  }
}
