import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  UseGuards,
  Query,
  Put,
} from '@nestjs/common';
import { CoinPackService } from './coin-pack.service';
import { CreateCoinPackDto } from './dto/create-coin-pack.dto';
import { UpdateCoinPackDto } from './dto/update-coin-pack.dto';
import { AuthGuard } from '@nestjs/passport';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';

@Controller('coin-pack')
export class CoinPackController {
  constructor(private readonly coinPackService: CoinPackService) {}

  @Post()
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  create(@Body() dto: CreateCoinPackDto) {
    return this.coinPackService.create(dto);
  }

  @Get('list')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN,UserRole.USER)
  findAll(@Query() dto: CommonPaginationDto) {
    return this.coinPackService.findAll(dto);
  }

  @Get('special')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.USER)
  getSpecial(){
    return this.coinPackService.getSpecial();
  }

  @Patch('update/:id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  update(@Param('id') id: string, @Body() dto: UpdateCoinPackDto) {
    return this.coinPackService.update(id, dto);
  }

  @Delete('remove/:id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  remove(@Param('id') id: string) {
    return this.coinPackService.remove(id);
  }
}
