import { Injectable } from '@nestjs/common';
import { CreateCoinHistoryDto } from './dto/create-coin-history.dto';
import { UpdateCoinHistoryDto } from './dto/update-coin-history.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { CoinHistory } from './entities/coin-history.entity';
import { Repository } from 'typeorm';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';

@Injectable()
export class CoinHistoryService {
  constructor(
    @InjectRepository(CoinHistory)
    private readonly repo: Repository<CoinHistory>,
  ) {}

  async create(dto: CreateCoinHistoryDto) {
    const obj = Object.assign(dto);
    return this.repo.save(obj);
  }

  async findAll(accountId: string, dto: CommonPaginationDto) {
    const [result, total] = await this.repo.findAndCount({
      where: { accountId },
      take: dto.limit,
      skip: dto.offset,
    });
    return { result, total };
  }

  findOne(id: number) {
    return `This action returns a #${id} coinHistory`;
  }

  update(id: number, updateCoinHistoryDto: UpdateCoinHistoryDto) {
    return `This action updates a #${id} coinHistory`;
  }

  remove(id: number) {
    return `This action removes a #${id} coinHistory`;
  }
}
