import { CategoryEvidence } from 'src/category-evidence/entities/category-evidence.entity';
import { CategorySuspect } from 'src/category-suspect/entities/category-suspect.entity';
import { CategoryPublishStatus, CategoryStatus, DefaultStatus } from 'src/enum';
import { Game } from 'src/game/entities/game.entity';
import { UserCategory } from 'src/user-category/entities/user-category.entity';
import { UserGame } from 'src/user-game/entities/user-game.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class Category {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  name: string;

  @Column({
    type: 'enum',
    enum: CategoryStatus,
    default: CategoryStatus.PENDING,
  })
  status: CategoryStatus;

  @Column({
    type: 'enum',
    enum: CategoryPublishStatus,
    default: CategoryPublishStatus.UNPUBLISH,
  })
  pubStatus: CategoryPublishStatus;

  @Column({ type: 'text', nullable: true })
  icon: string;

  @Column({ type: 'text', nullable: true })
  iconPath: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  caseNumber: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  crimeType: string;

  @Column({ type: 'date', nullable: true })
  publishDateFrom: string;

  @Column({ type: 'date', nullable: true })
  publishDateTo: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  catOpenTimer: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  catCloseTime: string;

  @Column({ type: 'text', nullable: true })
  image: string;

  @Column({ type: 'text', nullable: true })
  imagePath: string;

  @Column({ type: 'text', nullable: true })
  desc: string;

  @Column({ type: 'varchar', length: 200, nullable: true })
  location: string;

  @Column({ type: 'varchar', length: 200, nullable: true })
  timeWindow: string;

  @Column({ type: 'varchar', length: 200, nullable: true })
  discoveredBy: string;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @OneToMany(() => Game, (game) => game.category)
  game: Game[];

  @OneToMany(() => UserGame, (userGame) => userGame.category)
  userGame: UserGame[];

  @OneToMany(() => UserCategory, (userCategory) => userCategory.category)
  userCategory: UserCategory[];

  @OneToMany(() => CategoryEvidence, (categoryEvidence) => categoryEvidence.category)
  categoryEvidence: CategoryEvidence[];
  
  @OneToMany(() => CategorySuspect, (categorySuspect) => categorySuspect.category)
  categorySuspect: CategorySuspect[];
}
