import { Type } from 'class-transformer';
import { IsNotEmpty, IsOptional } from 'class-validator';

export class UpdateCategoryDto {
  @IsOptional()
  name: string;

  @IsOptional()
  caseNumber: string;

  @IsOptional()
  crimeType: string;

  @IsOptional()
  desc: string;
  
  @IsOptional()
  location: string;

  @IsOptional()
  timeWindow: string;

  @IsOptional()
  discoveredBy: string;
}

export class CategorySetTimeDto {
  @IsNotEmpty()
  publishDateFrom: string;

  @IsNotEmpty()
  catOpenTimer: string;

  @IsOptional()
  publishDateTo: string;

  @IsNotEmpty()
  catCloseTime: string;
}
