import { Type } from 'class-transformer';
import {
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';
import { CategoryPublishStatus, CategoryStatus } from 'src/enum';

export class CreateCategoryDto {
  @IsNotEmpty()
  name: string;

  @IsNotEmpty()
  caseNumber: string;

  @IsNotEmpty()
  desc: string;
  
  @IsNotEmpty()
  location: string;

  @IsNotEmpty()
  timeWindow: string;

  @IsNotEmpty()
  crimeType: string;

  @IsNotEmpty()
  discoveredBy: string;
}

export class CategoryPaginationDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(100)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(100)
  keyword: string;

  @IsOptional()
  status: CategoryStatus;

  @IsOptional()
  pubStatus: CategoryPublishStatus;
}

export class CategoryStatusDto {
  @IsOptional()
  status: CategoryStatus;

  @IsOptional()
  pubStatus: CategoryPublishStatus;
}
