import { Module } from '@nestjs/common';
import { CategoryService } from './category.service';
import { CategoryController } from './category.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Category } from './entities/category.entity';
import { AuthModule } from 'src/auth/auth.module';
import { Account } from 'src/account/entities/account.entity';
import { CategoryCronService } from './category.cron.service';
import { Game } from 'src/game/entities/game.entity';

@Module({
  imports: [TypeOrmModule.forFeature([Category, Account, Game]), AuthModule],
  controllers: [CategoryController],
  providers: [CategoryService,CategoryCronService],
})
export class CategoryModule {}
