import { Category } from 'src/category/entities/category.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class CategorySuspect {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  categoryId: string;

  @Column({type: 'varchar', length: 100, nullable: true})
  name: string;

  @Column({type: 'varchar', length: 100, nullable: true})
  role: string;

  @Column({type: 'varchar', length: 500, nullable: true})
  motive: string;

  @Column({type: 'varchar', length: 500, nullable: true})
  alibi: string;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Category, (category) => category.categorySuspect, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  category: Category[];
}
