import { IsNotEmpty, MinLength } from 'class-validator';

export class CreateCategorySuspectDto {
  @IsNotEmpty()
  categoryId: string;

  @IsNotEmpty()
  @MinLength(1)
  name: string;

  @IsNotEmpty()
  @MinLength(1)
  role: string;

  @IsNotEmpty()
  @MinLength(1)
  motive: string;

  @IsNotEmpty()
  @MinLength(1)
  alibi: string;
}
