import { Injectable, NotFoundException } from '@nestjs/common';
import { CreateCategorySuspectDto } from './dto/create-category-suspect.dto';
import { UpdateCategorySuspectDto } from './dto/update-category-suspect.dto';
import { CategorySuspect } from './entities/category-suspect.entity';
import { InjectRepository } from '@nestjs/typeorm';
import { Like, Repository } from 'typeorm';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';

@Injectable()
export class CategorySuspectService {
  constructor(
    @InjectRepository(CategorySuspect)
    private readonly repo: Repository<CategorySuspect>,
  ) {}

  async create(dto: CreateCategorySuspectDto) {
    const obj = Object.assign(dto);
    return this.repo.save(obj);
  }

  async findAll(categoryId: string, dto: CommonPaginationDto) {
    const keyword = dto.keyword || '';
    const [result, total] = await this.repo.findAndCount({
      where: {
        categoryId,
        name: Like('%' + keyword + '%'),
        role: Like('%' + keyword + '%'),
        motive: Like('%' + keyword + '%'),
        alibi: Like('%' + keyword + '%'),
      },
      take: dto.limit,
      skip: dto.offset,
    });
    return { result, total };
  }

  async update(id: string, dto: UpdateCategorySuspectDto) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Suspect Not Found..');
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }

  async remove(id: string) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new Error('Suspect Not Found..');
    }
    return this.repo.remove(result);
  }
}
