import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  UseGuards,
  Query,
} from '@nestjs/common';
import { CategorySuspectService } from './category-suspect.service';
import { CreateCategorySuspectDto } from './dto/create-category-suspect.dto';
import { UpdateCategorySuspectDto } from './dto/update-category-suspect.dto';
import { AuthGuard } from '@nestjs/passport';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';

@Controller('category-suspect')
export class CategorySuspectController {
  constructor(
    private readonly categorySuspectService: CategorySuspectService,
  ) {}

  @Post()
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  create(@Body() dto: CreateCategorySuspectDto) {
    return this.categorySuspectService.create(dto);
  }

  @Get('list/:categoryId')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  findAll(
    @Param('categoryId') categoryId: string,
    @Query() dto: CommonPaginationDto,
  ) {
    return this.categorySuspectService.findAll(categoryId, dto);
  }

  @Patch('update/:id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  update(@Param('id') id: string, @Body() dto: UpdateCategorySuspectDto) {
    return this.categorySuspectService.update(id, dto);
  }

  @Delete('remove/:id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  remove(@Param('id') id: string) {
    return this.categorySuspectService.remove(id);
  }
}
