import { Injectable, NotFoundException } from '@nestjs/common';
import { CreateCategoryEvidenceDto } from './dto/create-category-evidence.dto';
import { UpdateCategoryEvidenceDto } from './dto/update-category-evidence.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { CategoryEvidence } from './entities/category-evidence.entity';
import { Like, Repository } from 'typeorm';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';

@Injectable()
export class CategoryEvidenceService {
  constructor(
    @InjectRepository(CategoryEvidence)
    private readonly repo: Repository<CategoryEvidence>,
  ) {}

  async create(dto: CreateCategoryEvidenceDto) {
    const obj = Object.assign(dto);
    return this.repo.save(obj);
  }

  async findAll(categoryId: string, dto: CommonPaginationDto) {
    const keyword = dto.keyword || '';
    const [result, total] = await this.repo.findAndCount({
      where: {
        categoryId,
        heading: Like('%' + keyword + '%'),
        desc: Like('%' + keyword + '%'),
      },
      take: dto.limit,
      skip: dto.offset,
    });
    return { result, total };
  }

  async update(id: string, dto: UpdateCategoryEvidenceDto) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Category Evidence Not Found..');
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }

  async remove(id: string) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new Error('Category Evidence Not Found..');
    }
    return this.repo.remove(result);
  }
}
